define([
    'backbone',
    'Layout',
    'modules/community-care-request/new-appointment-request-question/preferred-provider/choices/choice-layout-view', // eslint-disable-line max-len
    'modules/community-care-request/new-appointment-request-question/preferred-provider/choices/choice-section-view', // eslint-disable-line max-len
], function(
    Backbone,
    Layout,
    ChoiceLayoutView,
    ChoiceSectionView
) {
    'use strict';
    describe('Choice Section', function() {
        var view;
        var $view;
        var model;
        var layout;
        var collection;
        var provider1;
        var provider2;

        beforeEach(function() {
            spyOn(ChoiceSectionView.prototype, 'trigger');
            spyOn(ChoiceSectionView.prototype, 'hideAddBtn');
            spyOn(ChoiceSectionView.prototype, 'hideDeleteBtn');
            spyOn(ChoiceSectionView.prototype, 'showDeleteBtn');
            spyOn(ChoiceSectionView.prototype, 'showAddBtn');

            layout = new Layout();
            layout.render();
            provider1 = new Backbone.Model({ 'id': 1 });
            model = new Backbone.Model({steps: [5], officeHours: []});
            model.set('preferredProviders', new Backbone.Collection(provider1));

            view = new ChoiceSectionView({
                model: model,
                id: 1,
            });
            layout.showChildView('content', view);
            $view = view.$el;
        });


        afterEach(function () {
            layout.getRegion('content').empty();
        });

        describe('when it shows the section', function() {
            beforeEach(function() {
                provider1 = new Backbone.Model({ 'id': 1 });
                provider2 = new Backbone.Model({ 'id': 2 });
                collection = new Backbone.Collection(provider1);
                model = new Backbone.Model({
                    steps: [5],
                    preferredProviders: collection,
                });
                model.get('preferredProviders').add(provider2);
                view = new ChoiceSectionView({
                    model: model,
                    id: 2,
                });
                layout.showChildView('content', view);
            });

            afterEach(function () {
                layout.getRegion('content').empty();
            });
            it('hides the delete button when length is at 2', function() {
                expect(view.hideAddBtn).toHaveBeenCalled();
                expect(view.showDeleteBtn).toHaveBeenCalled();
            });

            it('displays hides the button when length is one', function() {
                expect(view.hideAddBtn).toHaveBeenCalled();
                expect(view.hideDeleteBtn).toHaveBeenCalled();
                expect(view.showAddBtn).toHaveBeenCalled();
            });
        });

        describe('when the click add button event happens', function() {
            it('triggers the addevent', function() {
                provider1 = new Backbone.Model({ 'id': 1 });
                provider2 = new Backbone.Model({ 'id': 2 });
                collection = new Backbone.Collection(provider1);
                model = new Backbone.Model({
                    steps: [5],
                    preferredProviders: collection,
                });
                model.get('preferredProviders').add(provider2);
                view = new ChoiceSectionView({
                    model: model,
                    id: 2,
                });
                view.render();
                $view.find('.add-provider > button').click();
                expect(view.hideAddBtn).toHaveBeenCalled();
                expect(view.trigger).toHaveBeenCalledWith('provider:add');
            });
        });

        describe('when the click delete button event happens', function() {
            it('triggers the event deleteProvider', function() {
                provider1 = new Backbone.Model({ 'id': 1 });
                provider2 = new Backbone.Model({ 'id': 2 });
                collection = new Backbone.Collection(provider1);
                model = new Backbone.Model({
                    steps: [5],
                    preferredProviders: collection,
                });
                model.get('preferredProviders').add(provider2);
                view = new ChoiceSectionView({
                    model: model,
                    id: 2,
                });
                layout.showChildView('content', view);
                $view = view.$el;
                $view.find('.delete-provider > button').click();
            
                expect(view.trigger).toHaveBeenCalledWith('provider:delete', view.id);
            });
        });

        describe('when there is a change for adress model', function() {
            it('updates when one field is set', function() {
                provider1 = new Backbone.Model({
                    id: 1,
                    providerStreet: '123 Testing St',
                });
                collection = new Backbone.Collection(provider1);
                model = new Backbone.Model({
                    steps: [5],
                    preferredProviders: collection,
                });
                view = new ChoiceSectionView({
                    model: model,
                    id: 1,
                });
                view.render();
                view.modifyProviderAddress(model);
                expect(view.model.get('address')).toEqual({ street: '123 Testing St', city: '', state: '', zipCode: '' });
            });
         
            it('updates when all fields are set', function() {
                provider1 = new Backbone.Model({
                    id: 1,
                    providerStreet: '123 benbentwo St',
                    providerCity: 'Schulhof Town',
                    providerState: 'JH',
                    providerZipCode: 'bb222',
                });
                collection = new Backbone.Collection(provider1);
                model = new Backbone.Model({
                    steps: [5],
                    preferredProviders: collection,
                });
                view = new ChoiceSectionView({
                    model: model,
                    id: 1,
                });
                view.render();
                view.modifyProviderAddress(model);
                expect(view.model.get('address')).toEqual({ street: '123 benbentwo St', city: 'Schulhof Town', state: 'JH', zipCode: 'bb222' });
                
            });
        });
    });
});
